Attribute VB_Name = "mod_GPIBwrapper"
'This module is used to "wrap" typical (send, receive, etc) GPIB
'commands, which then get formatted for the specific GPIB card.
'The initial version of the module support the CEC488 GPIB
'card (KPCI-488, KPC-488.2AT) and the National Instruments GPIB
'card (PCI-GPIB, PCMCIA-GPIB, possibly AT-GPIB/TNT)
'
'
'Initial Release:   08/22/01
'based on earlier changes to the CEC driver module (ieeevb.bas)
'
'Requirements:
'CEC GPIB driver:       ieeevb.bas
'NI GPIB driver files:  niglobal.bas
'                       vbib-32.bas
'
'Variable: frmGPIBSettings.CommOpt() for choosing CEC or NI
'
'Revisions:
'       ??      - Add SendKI, QueryKI, PollKI, GetAddress, GPIBerror to permit the use of
'                 either CEC, NI, or RS-232 communication to instrument(s)
'                 (NI modules niglobal.bas and vbib-32.bas required for NI GPIB card)
'       8/15/01 - Comment out RS-232 code for 2520 VB Demo (RS-232 is too slow for data trans)
'       8/15/01 - Add BqueryKI for binary data transfer
'v02    10/5/01 - Clean up comments, add consistent error reporting code, fix error check for NI cards, add SrqKI

Global Const BRDNUM = 0                         'GPIB card/controller #, required for NI routines
Global kidev As Integer                         'GPIB address for instrument
Global Abort As Integer
Global Running As Integer
'Global numBytes As Integer

Sub EnableEvents()
    commset.GPIBAddress.Enabled = True
    commset.GPIBCommands.Enabled = True
    commset.SendCmd.Enabled = True
    commset.GetResponse.Enabled = True
    commset.DispCmd.Enabled = True
    commset.DDCMode.Enabled = True
    commset.SaveSettings.Enabled = True
    commset.DataPathSelect.Enabled = True
    commset.ComPortSelect.Enabled = True
    commset.BaudRateSelect.Enabled = True
    commset.DataBitsSelect.Enabled = True
    commset.StopBitsSelect.Enabled = True
    commset.ParitySelect.Enabled = True
    commset.SendGet.Enabled = True
    If commset.DDCMode.value = False Then
        commset.GetErr.Enabled = True
        commset.DisableDisplay.Enabled = True
        commset.NextCalCmd.Enabled = True
    End If
    Running = False
    commset.ExitButton.Caption = "Exit"
    commset.GPIBCommands.SetFocus
End Sub

Function GetAddress() As Integer
    
    Abort = False
    If (frmGPIBSettings.CommOpt(0).value) Or (frmGPIBSettings.CommOpt(1).value) Then
'        kidev = Val(frmGPIBSettings.GPIBAddress.Text)
'        If kidev < 0 Or kidev > 30 Then
'            MsgBox "Invalid GPIB Address!" + Chr$(10) + "Must be from 0-30!", 48, "Bad GPIB Address"
'            GetAddress = True
'            frmGPIBSettings.GPIBAddress.Text = "27"
'            Exit Function
'        End If
'        If frmGPIBSettings.CommOpt(0).value Then
'            Call setport(Val(frmGPIBSettings.GPIBbrd.Text), Val(frmGPIBSettings.GPIBioaddr.Text))
'        End If
    Else
        For X% = 0 To 9
            If commset.BaudRate(X%).value Then
                ComSet$ = commset.BaudRate(X%).Caption + ","
            End If
        Next X%
        For X% = 0 To 2
            If commset.Parity(X%).value Then
                ComSet$ = ComSet$ + Left$(commset.Parity(X%).Caption, 1) + ","
            End If
        Next X%
        For X% = 0 To 1
            If commset.DataBits(X%).value Then
                ComSet$ = ComSet$ + commset.DataBits(X%).Caption + ","
            End If
        Next X%
        For X% = 0 To 1
            If commset.StopBits(X%).value Then
                ComSet$ = ComSet$ + commset.StopBits(X%).Caption
            End If
        Next X%
        For X% = 0 To 3
            If commset.ComPort(X%).value Then
                port% = X% + 1
            End If
        Next X%
        If ComSet$ <> commset.Comm1.Settings Then
            commset.Comm1.Settings = ComSet$
        End If
        If commset.Comm1.CommPort <> port% Then
            If commset.Comm1.PortOpen Then
                commset.Comm1.PortOpen = False
            End If
            commset.Comm1.CommPort = port%
        End If
        If Not commset.Comm1.PortOpen Then
            commset.Comm1.PortOpen = True
        End If
    End If
    
    Running = True
    GetAddress = False
    commset.GPIBAddress.Enabled = False
    commset.GPIBCommands.Enabled = False
    commset.SendCmd.Enabled = False
    commset.GetResponse.Enabled = False
    commset.DispCmd.Enabled = False
    commset.DDCMode.Enabled = False
    commset.SaveSettings.Enabled = False
    commset.DataPathSelect.Enabled = False
    commset.ComPortSelect.Enabled = False
    commset.BaudRateSelect.Enabled = False
    commset.DataBitsSelect.Enabled = False
    commset.StopBitsSelect.Enabled = False
    commset.ParitySelect.Enabled = False
    commset.GetErr.Enabled = False
    commset.DisableDisplay.Enabled = False
    commset.NextCalCmd.Enabled = False
    commset.SendGet.Enabled = False
    commset.ExitButton.Caption = "STOP"
    DoEvents
End Function

Function GPIBError(Msg1$, Msg2$) As Integer
    
    Response = MsgBox(Msg1$ + Chr(10) + Msg2$ + Chr(10) + "Select OK to continue program or CANCEL to abort.", 1, "GPIB Error")
    
    GPIBError = False
    If Response = 1 Then
        If (frmGPIBSettings.CommOpt(0).value) Then
            Call initialize(21, 0)          ' CEC at IEEE address 21
            Call setoutputEOS(10, 0)        ' Set Output Terminator to LF^EOI
            Call setinputEOS(10)            ' Set Input Terminator to LF^EOI
            Call settimeout(1000)           ' Timeout of 1 seconds
'        Else
'            Call SendIFC(BRDNUM)
'            Call ibtmo(BRDNUM, T1s)
        End If
        TimeOutError = True
    ElseIf Response = 2 Then
        GPIBError = True
        Abort = True
        Call EnableEvents
    End If

End Function

Function PollKI(kidev As Integer)
'This function performs a serial poll on the instrument, which
'reads the status byte and clears the SRQ bit & front panel
'annunciator (if enabled)
    
    Dim poll As Integer
    Dim status As Integer

    If (frmGPIBSettings.CommOpt(0).value) Then      'CEC card chosen
        spoll kidev, poll, status
        If status <> 0 Then GoTo Err:
    ElseIf (frmGPIBSettings.CommOpt(1).value) Then
        ReadStatusByte 0, kidev, poll
        If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err:
    Else
        If commset.Comm1.InBufferCount Then
            poll = 16
        End If
    End If
    PollKI = poll
    
    Exit Function
    
Err:
    
    MsgBox "Error while serial polling instrument at GPIB address " & kidev, vbExclamation, "GPIB Error"
    
End Function

Function QueryKI(kidev As Integer) As String
'Procedure is a "wrapper" for the enter/recieve command for CEC, NI, RS-232 communication
    
    Dim length As Integer
    Dim status As Integer
    Dim Resp As String

'Comment out all RS-232 code, as it's not implemented for the demo
'    If (commset.CommOpt(2).value) Then
'        ' Read data.
'        commset.Comm1.InputLen = 0
'        Resp$ = ""
'        Do
'            Resp$ = Resp$ + commset.Comm1.Input
'            DoEvents
'            If Abort Then
'                QueryKI = Resp$
'                Exit Function
'            End If
'        Loop Until Len(Resp$) >= 1024 Or Right$(Resp$, 1) = Chr$(10) Or Right$(Resp$, 1) = Chr$(13)
'        If (Right$(Resp$, 1) = Chr$(10) Or Right$(Resp$, 1) = Chr$(13)) And Len(Resp$) > 1 Then
'            Resp$ = Left$(Resp$, Len(Resp$) - 1)
'        End If
'    ElseIf (commset.CommOpt(0).value) Then
    
    If (frmGPIBSettings.CommOpt(0).value) Then              'CEC card is used
        enter Resp, 4096, length, kidev, status
        If status <> 0 Then GoTo Err:
    ElseIf (frmGPIBSettings.CommOpt(1).value) Then      'NI board
        Resp$ = Space$(4096)
        NIReceive BRDNUM, kidev, Resp, LF
        If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err:
    End If
    QueryKI = Resp

    Exit Function

Err:

    MsgBox "Error while querying instrument at GPIB address " & kidev, vbExclamation, "GPIB Error"

End Function

Function SendKI(kidev As Integer, cmd As String) As Integer
'Procedure is a "wrapper" for the send command for CEC, NI, RS-232 communication
' was Function SendKI(cmd As String) As Integer
'8/15/01 RS-232 (Comm1) commented out, not appropriate for 2520 Demo

    Dim status As Integer
    
    SendKI = False
    If (frmGPIBSettings.CommOpt(0).value) Then          'CEC Card
        CECSend kidev, cmd, status
        If status <> 0 Then GoTo Err:
    ElseIf (frmGPIBSettings.CommOpt(1).value) Then      'NI Card
        NISend BRDNUM, kidev, cmd, NLend
        If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err:
    Else
        If Len(cmd) > 1 Then
            If Left$(cmd, 1) <> Chr$(10) Then
                cmd = cmd + Chr$(10)
            End If
        End If
'        frmGPIBSettings.Comm1.Output = cmd
'        Do
'            DoEvents
'            If Abort Then Exit Function
'        Loop Until commset.Comm1.OutBufferCount = 0
    End If
    
    Exit Function

Err:

    MsgBox "Error sending instructions to instrument at GPIB address " & kidev, vbExclamation, "GPIB Error"
    
End Function

Function RecSetupKI(kidev As Integer) As Integer
'Procedure is a "wrapper" for the Receive Setup (config instrument to talk)
'for the CEC and NI GPIB cards

    Dim status As Integer
    
    RecSetupKI = False
    If (frmGPIBSettings.CommOpt(0).value) Then                      'CEC Card
    '    transmit , cmd, status
        Call transmit("UNT UNL MLA TALK " & Str$(kidev), status)    'Address instrument to talk, GPIB board is listening
        If status <> 0 Then GoTo Err:
    
    ElseIf (frmGPIBSettings.CommOpt(1).value) Then                  'NI Card
    '    NISend BRDNUM, kidev, cmd, NLend
        Call ReceiveSetup(BRDNUM, kidev)                            'Set up instrument to talk, GPIB board is listening
        If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err:
    End If
    
    Exit Function
    
Err:
    
    MsgBox "GPIB Error while configuring instrument at address " & kidev & " to talk."

End Function

Public Sub RecBinaryKI(data As Single, numBytes As Long, length As Integer)
'Procedure is a "wrapper" for receiving data in binary (byte) form from the instrument
'for the CEC and NI GPIB cards

    Dim status As Long
    Dim leng As Long
    
    If (frmGPIBSettings.CommOpt(0).value) Then          'if CEC, use CEC commands
        Call IErarray(data, 2, leng, status)            ' Read "#0" from binary string
        If (status And 8) Then GoTo Err                 ' Check for timeout
        Call IErarray(data, numBytes, leng, status)     'Retrieve binary data, IErarry terminates on #ofbytes or EOI signal
        If (status And 8) Then GoTo Err                 'Check for timeout
        
        ElseIf (frmGPIBSettings.CommOpt(1).value) Then  'NI, so use NI commands
            Call RcvRespMsg32(BRDNUM, data, 2, STOPend) ' Read "#0" from binary string
            If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err 'Check for timeout or GPIB error
            Call RcvRespMsg32(BRDNUM, data, numBytes, STOPend) 'Retrieve binary data, read terminates on #ofbytes or when byte rec'd with EOI line asserted
            If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err 'Check for timeout or GPIB error
    End If
    
    length = leng                                       'Return actual (returned) length
    
    Exit Sub
    
Err:
    'Add Error handling code here
    MsgBox "Error during binary data transfer from instrument.", vbExclamation, "GPIB Error"

End Sub

Public Function RecUndoKI(kidev As Integer) As Integer
'Procedure is a "wrapper" for resetting the instrument from a talk (& GPIB card receive) setup
'for the CEC and NI GPIB cards

    Dim intStatus As Integer
    
    RecUndoKI = False
    If (frmGPIBSettings.CommOpt(0).value) Then              'CEC board
        Call transmit("UNT UNL", intStatus)                 'Stop instrument talking, GPIB from listening
        If (intStatus And 8) Then GoTo Err                  'Check for timeout
        ElseIf (frmGPIBSettings.CommOpt(1).value) Then      'NI board
            Call SendIFC(BRDNUM)                           'stop talking by sending InterFaceClear (IFC) command
            If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err 'Check for timeout or GPIB error
    End If
    
    Exit Function
    
Err:
    'Add Error handling code here
    MsgBox "Error while attempting to return instrument to Talk and GPIB to listen state.", vbExclamation, "GPIB Error"

End Function

Public Function GPIBInitialize(timeout As Integer)
'Procedure is a "wrapper" for the send command for CEC & NI GPIB communication
'Intialize the GPIB board and set timeouts

    Dim t As Integer
    Dim status As Integer
    
    If (frmGPIBSettings.CommOpt(0).value) Then      'CEC board
        Call initialize(21, 0)                      'Initialize GPIB card/controller to address 21, 0=system controller
        Call settimeout(timeout)                       'Set timeout = 3 seconds
        If (status And 8) Then GoTo Err                          ' Check for timeout
        ElseIf (frmGPIBSettings.CommOpt(1).value) Then      'NI board
            Call SendIFC(BRDNUM)                           'stop talking by sending InterFaceClear (IFC) command
            If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err 'Check for timeout or GPIB error
            t = Int(timeout / 1000)                 'Calculate number of seconds
            Call ibtmo(BRDNUM, "T" & t & "s")
            If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err 'Check for timeout or GPIB error
    End If
    
    Exit Function
    
Err:
    'Put error handling routines here
    MsgBox "Error during initialization of GPIB card.", vbExclamation, "GPIB Error"

End Function

Public Function SrqKI() As Integer
'Procedure is a wrapper for the GPIB SRQ (serice request) command
'for both the CEC/Keithley and NI card/controllers
Dim intResult As Integer

If (frmGPIBSettings.CommOpt(0).value) Then      'CEC board
    intResult = srq
    ElseIf (frmGPIBSettings.CommOpt(1).value) Then      'NI board
        Call TestSRQ(BRDNUM, intResult)
        If (ibsta And (ERR_488 Or TIMO)) <> 0 Then GoTo Err 'Check for timeout or GPIB error
End If

SrqKI = intResult

Exit Function

Err:

MsgBox "Error during query of SRQ status.", vbExclamation, "GPIB Error"

End Function

